-----------------------------------
-- Boost limit point gain for lvl 75 WEW/CW based on merits in merit storage increase
-----------------------------------
require("modules/module_utils")
require("scripts/globals/player")
-----------------------------------
local m = Module:new("limit_point_gain_boost")

local meritValueCache = '[WEW]IncreaseMeritCapPoints'

local limitPointExpBonus = function(player)
    -- we pull the players explicit level of their current main job, to avoid issues when a player zones into level sync
    if
        player:getJobLevel(player:getMainJob()) >= 75 and
        (player:isCrystalWarrior() or
        player:isClassicMode())
    then
        -- max_merits category has power 1, so this will give
        -- 5% xp bonus per for first 5 points
        -- 6% xp bonus per for next 5 points
        -- 9% xp bonus per for last 5 points
        -- for a max of 100% xp bonus when lvl 75
        local meritPoints = player:getMerit(xi.merit.MAX_MERIT)
        if meritPoints == 0 then
            -- we pull the cached value here in case the player zoned into a level sync
            meritPoints = player:getCharVar(meritValueCache)
        end

        -- cache the value for next time regardless
        player:setCharVar(meritValueCache, meritPoints)
        local xpBonus = 0
        if meritPoints <= 5 then
            xpBonus = meritPoints * 5
        elseif meritPoints <= 10 then
            xpBonus = 25 + (meritPoints - 5) * 6
        elseif meritPoints <= 15 then
            xpBonus = 25 + 30 + (meritPoints - 10) * 9
        end

        return xpBonus
    else
        return 0
    end
end

m:addOverride("xi.player.onGameIn", function(player, firstLogin, zoning)
    super(player, firstLogin, zoning)

    local lpBonus = limitPointExpBonus(player)
    if lpBonus > 0 then
        player:addMod(xi.mod.EXP_BONUS, lpBonus)
    end
end)

m:addOverride("xi.player.onPlayerLevelUp", function(player)
    super(player)

    -- will technically fail if they have moghancement, but better than nothing and want to be sure there's no exploit of de-level to 74, level to 75 to stack the bonus
    -- simply zone to get the bonus from the onGameIn
    local lpBonus = limitPointExpBonus(player)
    if
        lpBonus > 0 and
        player:getMod(xi.mod.EXP_BONUS) == 0
    then
        player:setMod(xi.mod.EXP_BONUS, lpBonus)
    end
end)

return m
