-----------------------------------
-- Prevent Automaton from overriding sync
-----------------------------------
require("modules/module_utils")
require("scripts/globals/player")
-----------------------------------
local m = Module:new("level_sync_pup_fix")

m:addOverride("xi.effects.level_sync.onEffectGain", function(target, effect)
    if target:getObjType() == xi.objType.PC then
        local pet = target:getPet()

        if pet ~= nil and pet:isAutomaton() then
            target:despawnPet()
        end
    end

    super(target, effect)
end)

return m
