-----------------------------------
-- Old setting from settings.lua: HOMEPOINT_HEAL
-- Set if you want Home Points to heal you like in single-player Final Fantasy games.
-----------------------------------
require('modules/module_utils')
require('scripts/globals/homepoint')
-----------------------------------
local m = Module:new('homepoint_heal')

local noHealZones =
{
    xi.zone.ALTAIEU,
    xi.zone.GRAND_PALACE_OF_HUXZOI,
    xi.zone.THE_GARDEN_OF_RUHMET,
    xi.zone.EMPYREAL_PARADOX,
    xi.zone.TEMENOS,
    xi.zone.APOLLYON,
    xi.zone.CASTLE_ZVAHL_KEEP
}

m:addOverride('xi.homepoint.onTrigger', function(player, csid, index)
    -- apparently people ar exploiting the healing homepoints so we implement a check to see
    -- if they are in a "no heal zone" as defined in the table at the top of the file.
    local currentZone = player:getZoneID()
    local healAllowed = true

    for _, restrictedZone in ipairs(noHealZones) do
        if currentZone == restrictedZone then
            healAllowed = false
        end
    end

    if not healAllowed then
        player:printToPlayer("NOTE: HP/MP refills are disabled in this area.")
    else
        player:addHP(player:getMaxHP())
        player:addMP(player:getMaxMP())
    end

    super(player, csid, index)
end)

return m
