-----------------------------------
-- Repatriation for Dual-Boxing CW/WEW with ACE in same zone
-----------------------------------
require("modules/module_utils")
require("scripts/globals/player")
-----------------------------------
local m = Module:new("dual_boxing_restrictions")


local allowedZones =
{
    xi.zone.PORT_SAN_DORIA,
    xi.zone.NORTHERN_SAN_DORIA,
    xi.zone.SOUTHERN_SAN_DORIA,
    xi.zone.PORT_BASTOK,
    xi.zone.BASTOK_MINES,
    xi.zone.BASTOK_MARKETS,
    xi.zone.WINDURST_WATERS,
    xi.zone.PORT_WINDURST,
    xi.zone.WINDURST_WALLS,
    xi.zone.WINDURST_WOODS,
    xi.zone.SOUTHERN_SAN_DORIA_S,
    xi.zone.BASTOK_MARKETS_S,
    xi.zone.WINDURST_WATERS_S,
    xi.zone.SELBINA,
    xi.zone.RABAO,
    xi.zone.NORG,
    xi.zone.RULUDE_GARDENS,
    xi.zone.UPPER_JEUNO,
    xi.zone.LOWER_JEUNO,
    xi.zone.PORT_JEUNO,
    xi.zone.METALWORKS,
    xi.zone.MHAURA,
    xi.zone.KAZHAM,
    xi.zone.AL_ZAHBI,
    xi.zone.AHT_URHGAN_WHITEGATE,
    xi.zone.NASHMAU,
    xi.zone.TAVNAZIAN_SAFEHOLD,
    xi.zone.MORDION_GAOL,
}

m:addOverride("xi.player.onGameIn", function(player, firstLogin, zoning)
    super(player, firstLogin, zoning)

    local currentZone = player:getZoneID()
    local inTown = false
    for _, allowedZone in ipairs(allowedZones) do
        if currentZone == allowedZone then
            inTown = true
        end
    end

    if not inTown then
        local repatChar = false
        -- wew allowed to dualbox now, but leaving function for posterity
        local function charIsEra(playerArg)
            return playerArg:isClassicMode() or playerArg:isCrystalWarrior()
        end

        for _, char in pairs(player:getLinkedCharsInZone()) do
            if char:getName() == player:getName() then
                -- Do nothing, though this shouldn't be possible since char objects aren't in the pchar list for the zone, so they don't get returned
            elseif
                (player:isCrystalWarrior() and player:getCharVar("[CW]INTRO") > 8) or
                (char:isCrystalWarrior() and char:getCharVar("[CW]INTRO") > 8)
            then
                -- This should catch all scenarios
                -- Captured here: Linked characters that are cw entering zone with either another cw or ace
                -- Captured here: Linked characters that are not cw entering zone with either another cw
                -- Excluded: Linked characters that are ace/wew entering a zone with another ace/wew
                repatChar = true
            end
        end

        if repatChar then
            -- SUPER GRAVITY
            local typeEffect = xi.effect.WEIGHT
            player:addStatusEffect(typeEffect, 85, 0, 600)
            local statusEffect = player:getStatusEffect(typeEffect)
            -- still erasable for some reason, but will leave this here in case someone wants to try to fixit. Sending to home nation is good enough on its own
            statusEffect:delEffectFlag(xi.effectFlag.ERASABLE)
            statusEffect:delEffectFlag(xi.effectFlag.WALTZABLE)

            player:addStatusEffectEx(xi.effect.TELEPORT, 0, xi.teleport.id.HOME_NATION, 0, 15)
            player:timer(8000, function(playerArg)
                playerArg:sys("You are not allowed in this zone due to dual-boxing restrictions.")
                playerArg:sys("Before continuing, please apply for an IP Exception under #gm-support on discord (discord.gg/catseyexi).")
            end)
        end
    end
end)

return m
