-----------------------------------
-- Global blue magic modifications
-----------------------------------
require("modules/module_utils")
require("scripts/globals/bluemagic")
-----------------------------------
local m = Module:new("bluemagic")

local spellMods = {
    [xi.magic.spell.ASURAN_CLAWS] = {
        ['params'] = {
            ['multiplier'] = 1.0,
            ['tp150'] = 3.5,
            ['tp300'] = 3.5,
            ['azuretp'] = 3.5,
            ['duppercap'] = 90,
            ['str_wsc'] = 0.2,
        },
    },
    [xi.magic.spell.BLITZSTRAHL] = {
        ['params'] = {
            ['multiplier'] = 3.5,
        },
        ['addEffect'] = {
            ['duration'] = 15, -- should last up to 15s
        },
    },
    [xi.magic.spell.BLUDGEON] = {
        ['params'] = {
            ['multiplier'] = 2.6,
            ['tp150'] = 2.6,
            ['tp300'] = 2.6,
            ['azuretp'] = 2.6,
        },
    },
    [xi.magic.spell.BODY_SLAM] = {
        ['params'] = {
            ['multiplier'] = 4.0,
            ['tp150'] = 4.5,
            ['tp300'] = 5.0,
            ['azuretp'] = 5.25,
        },
    },
    [xi.magic.spell.BOMB_TOSS] = {
        ['params'] = {
            ['multiplier'] = 2.5,
        },
    },
    [xi.magic.spell.CANNONBALL] = {
        ['params'] = {
            ['multiplier'] = 3.3,
            ['tp150'] = 3.6,
            ['tp300'] = 3.9,
            ['azuretp'] = 4.1,
        },
    },
    [xi.magic.spell.CLAW_CYCLONE] = {
        ['params'] = {
            ['multiplier'] = 2.8,
            ['tp150'] = 3.1,
            ['tp300'] = 3.4,
            ['azuretp'] = 3.5,
        },
    },
    [xi.magic.spell.CORROSIVE_OOZE] = {
        ['params'] = {
            ['multiplier'] = 3.2,
            ['azuretp'] = 1.5,
        },
    },
    [xi.magic.spell.CURSED_SPHERE] = {
        ['params'] = {
            ['multiplier'] = 2.1,
        },
    },
    [xi.magic.spell.DEATH_RAY] = {
        ['params'] = {
            ['multiplier'] = 4.2,
        },
    },
    [xi.magic.spell.DEATH_SCISSORS] = {
        ['params'] = {
            ['multiplier'] = 3.8,
            ['tp150'] = 4.1,
            ['tp300'] = 4.4,
            ['azuretp'] = 4.5,
        },
    },
    [xi.magic.spell.DIMENSIONAL_DEATH] = {
        ['params'] = {
            ['multiplier'] = 3.7,
            ['tp150'] = 4.0,
            ['tp300'] = 4.3,
            ['azuretp'] = 4.4,
        },
    },
    [xi.magic.spell.DISSEVERMENT] = {
        ['params'] = {
            ['multiplier'] = 3.0,
            ['tp150'] = 3.0,
            ['tp300'] = 3.0,
            ['azuretp'] = 3.0,
        },
    },
    [xi.magic.spell.EYES_ON_ME] = {
        ['params'] = {
            ['multiplier'] = 4.4,
        },
    },
    [xi.magic.spell.FIRESPIT] = {
        ['params'] = {
            ['multiplier'] = 4.6,
        },
    },
    [xi.magic.spell.FOOT_KICK] = {
        ['params'] = {
            ['multiplier'] = 1.6,
            ['tp150'] = 1.6,
            ['tp300'] = 1.6,
            ['azuretp'] = 1.6,
        },
    },
    [xi.magic.spell.FRENETIC_RIP] = {
        ['params'] = {
            ['multiplier'] = 4.0,
            ['tp150'] = 4.3,
            ['tp300'] = 4.6,
            ['azuretp'] = 4.7,
        },
    },
    [xi.magic.spell.FRYPAN] = {
        ['params'] = {
            ['multiplier'] = 3.5,
            ['tp150'] = 3.5,
            ['tp300'] = 3.5,
            ['azuretp'] = 3.5,
        },
        ['addEffect'] = {
            ['duration'] = 5,
        },
    },
    [xi.magic.spell.GRAND_SLAM] = {
        ['params'] = {
            ['multiplier'] = 3.0,
            ['tp150'] = 3.5,
            ['tp300'] = 4.0,
            ['azuretp'] = 4.2,
        },
    },
    [xi.magic.spell.HEAD_BUTT] = {
        ['params'] = {
            ['multiplier'] = 1.8,
            ['tp150'] = 2.0,
            ['tp300'] = 2.2,
            ['azuretp'] = 2.27,
        },
        ['addEffect'] = {
            ['duration'] = 5,
        },
    },
    [xi.magic.spell.HELLDIVE] = {
        ['params'] = {
            ['multiplier'] = 3.3,
            ['tp150'] = 3.7,
            ['tp300'] = 4.1,
            ['azuretp'] = 4.23,
        },
    },
    [xi.magic.spell.HYDRO_SHOT] = {
        ['params'] = {
            ['multiplier'] = 3.2,
            ['tp150'] = 3.2,
            ['tp300'] = 3.2,
            ['azuretp'] = 3.2,
        },
    },
    [xi.magic.spell.HYSTERIC_BARRAGE] = {
        ['params'] = {
            ['multiplier'] = 4.7,
            ['tp150'] = 5.1,
            ['tp300'] = 5.5,
            ['azuretp'] = 5.63,
        },
    },
    [xi.magic.spell.ICE_BREAK] = {
        ['params'] = {
            ['multiplier'] = 3.2,
        },
    },
    [xi.magic.spell.JET_STREAM] = {
        ['params'] = {
            ['multiplier'] = 4.9,
            ['tp150'] = 4.9,
            ['tp300'] = 4.9,
            ['azuretp'] = 4.9,
        },
    },
    [xi.magic.spell.MAGIC_HAMMER] = {
        ['params'] = {
            ['multiplier'] = 1.75,
        },
    },
    [xi.magic.spell.MANDIBULAR_BITE] = {
        ['params'] = {
            ['multiplier'] = 3.8,
            ['tp150'] = 4.3,
            ['tp300'] = 4.8,
            ['azuretp'] = 4.96,
        },
    },
    [xi.magic.spell.MIND_BLAST] = {
        ['params'] = {
            ['multiplier'] = 3.6,
        },
    },
    [xi.magic.spell.MYSTERIOUS_LIGHT] = {
        ['params'] = {
            ['multiplier'] = 3.5,
        },
    },
    [xi.magic.spell.PINECONE_BOMB] = {
        ['params'] = {
            ['multiplier'] = 2.7,
            ['tp150'] = 2.7,
            ['tp300'] = 2.7,
            ['azuretp'] = 2.7,
        },
    },
    [xi.magic.spell.POWER_ATTACK] = {
        ['params'] = {
            ['multiplier'] = 1.6,
            ['tp150'] = 1.6,
            ['tp300'] = 1.6,
            ['azuretp'] = 1.6,
        },
    },
    [xi.magic.spell.RAM_CHARGE] = {
        ['params'] = {
            ['multiplier'] = 4.0,
            ['tp150'] = 4.5,
            ['tp300'] = 5.0,
            ['azuretp'] = 5.16,
        },
    },
    [xi.magic.spell.REGURGITATION] = {
        ['params'] = {
            ['multiplier'] = 3.0,
        },
    },
    [xi.magic.spell.SCREWDRIVER] = {
        ['params'] = {
            ['multiplier'] = 3.1,
            ['tp150'] = 3.1,
            ['tp300'] = 3.1,
            ['azuretp'] = 3.1,
        },
    },
    [xi.magic.spell.SEEDSPRAY] = {
        ['params'] = {
            ['multiplier'] = 3.2,
            ['tp150'] = 3.2,
            ['tp300'] = 3.2,
            ['azuretp'] = 3.2,
            ['int_wsc'] = 0.2,
        },
    },
    [xi.magic.spell.SICKLE_SLASH] = {
        ['params'] = {
            ['multiplier'] = 3.8,
            ['tp150'] = 3.8,
            ['tp300'] = 3.8,
            ['azuretp'] = 3.8,
        },
    },
    [xi.magic.spell.SMITE_OF_RAGE] = {
        ['params'] = {
            ['multiplier'] = 3.3,
            ['tp150'] = 3.9,
            ['tp300'] = 4.5,
            ['azuretp'] = 4.7,
        },
    },
    [xi.magic.spell.SPINAL_CLEAVE] = {
        ['params'] = {
            ['multiplier'] = 5.5,
            ['tp150'] = 5.5,
            ['tp300'] = 5.5,
            ['azuretp'] = 5.5,
        },
    },
    [xi.magic.spell.SPIRAL_SPIN] = {
        ['params'] = {
            ['multiplier'] = 2.7,
            ['tp150'] = 2.7,
            ['tp300'] = 2.7,
            ['azuretp'] = 2.7,
            ['int_wsc'] = 0.10,
        },
    },
    [xi.magic.spell.SUB_ZERO_SMASH] = {
        ['params'] = {
            ['multiplier'] = 4.0,
            ['tp150'] = 4.5,
            ['tp300'] = 5.0,
            ['azuretp'] = 5.16,
        },
    },
    [xi.magic.spell.SUDDEN_LUNGE] = {
        ['addEffect'] = {
            ['duration'] = 20,
        },
    },
    [xi.magic.spell.TAIL_SLAP] = {
        ['params'] = {
            ['multiplier'] = 3.6,
            ['tp150'] = 4.0,
            ['tp300'] = 4.4,
            ['azuretp'] = 4.63,
        },
    },
    [xi.magic.spell.TERROR_TOUCH] = {
        ['params'] = {
            ['multiplier'] = 3,
            ['tp150'] = 3,
            ['tp300'] = 3,
            ['azuretp'] = 3,
        },
    },
    [xi.magic.spell.UPPERCUT] = {
        ['params'] = {
            ['multiplier'] = 3.2,
            ['tp150'] = 3.8,
            ['tp300'] = 4.4,
            ['azuretp'] = 4.6,
        },
    },
    [xi.magic.spell.VERTICAL_CLEAVE] = {
        ['params'] = {
            ['multiplier'] = 5.1,
            ['tp150'] = 6.6,
            ['tp300'] = 8.1,
            ['azuretp'] = 8.8,
        },
    },
}

local adjustParams = function(caster, target, spellID, params)
    if
        spellMods[spellID] and
        spellMods[spellID]['params']
    then
        for k, v in pairs(spellMods[spellID]['params']) do
            params[k] = v
        end
    end
end

local multiplierBasedOnSkill = function(caster)
    -- Scale all blu damage by a 1% every 2 blu magic difference from cap
    local bluLvl     = caster:getMainJob() == xi.job.BLU and caster:getMainLvl() or caster:getSubLvl()
    local skill      = caster:getSkillLevel(xi.skill.BLUE_MAGIC)
    local maxSkill   = caster:getMaxSkillLevel(bluLvl, xi.job.BLU, xi.skill.BLUE_MAGIC)
    local multiplier = (utils.clamp((skill - maxSkill) / 2, -50, 50) + 100) / 100

    return multiplier
end

m:addOverride("xi.spells.blue.usePhysicalSpell", function(caster, target, spell, params)
    local spellID = spell:getID()
    adjustParams(caster, target, spellID, params)

    return super(caster, target, spell, params)
end)

m:addOverride("xi.spells.blue.useMagicalSpell", function(caster, target, spell, params)
    local spellID = spell:getID()
    adjustParams(caster, target, spellID, params)

    return super(caster, target, spell, params)
end)

m:addOverride("xi.spells.blue.useEnfeeblingSpell", function(caster, target, spell, params, power, tick, duration, resistThreshold, isGaze, isConal)
    return super(caster, target, spell, params, power, tick, duration, resistThreshold, isGaze, isConal)
end)

m:addOverride("xi.spells.blue.useBreathSpell" , function(caster, target, spell, params, isConal)
    return super(caster, target, spell, params, isConal)
end)

m:addOverride("xi.spells.blue.usePhysicalSpellAddedEffect", function(caster, target, spell, params, damage, power, tick, duration)
    local newDuration = duration
    local spellID = spell:getID()
    if
        spellMods[spellID] and
        spellMods[spellID]['addEffect']
    then
        -- not quite as elegant as above, but it works for now
        if spellMods[spellID]['addEffect']['duration'] then
            newDuration = spellMods[spellID]['addEffect']['duration']
        end
    end

    super(caster, target, spell, params, damage, power, tick, newDuration)
end)

m:addOverride("xi.spells.blue.useMagicalSpellAddedEffect", function(caster, target, spell, params, power, tick, duration)
    local newDuration = duration
    local spellID = spell:getID()
    if
        spellMods[spellID] and
        spellMods[spellID]['addEffect']
    then
        -- not quite as elegant as above, but it works for now
        if spellMods[spellID]['addEffect']['duration'] then
            newDuration = spellMods[spellID]['addEffect']['duration']
        end
    end

    super(caster, target, spell, params, power, tick, newDuration)
end)

m:addOverride("xi.spells.blue.applySpellDamage", function(caster, target, spell, dmg, params, trickAttackTarget)
    local skillMult = multiplierBasedOnSkill(caster)
    local spellID = spell:getID()

    -- Quick patch for LSB's new change
    if params.tphitslanded == nil then
        params.tphitslanded = 1
    end

    -- Adjust for Magical Conal spells
    if spellID == xi.magic.spell.ACRID_STREAM or spellID == xi.magic.spell.EMPTY_THRASH then
        local isInCone = 0
        if target:isInfront(caster, 32) then
            isInCone = 1
        end

        dmg = dmg * isInCone
    end

    -- Adjust for MDB instead of MAB (Blazing Bound)
    if spellID == xi.magic.spell.BLAZING_BOUND then
        local mab = caster:getMod(xi.mod.MATT)
        local mdb = caster:getMod(xi.mod.MDEF)
        local tmdb = target:getMod(xi.mod.MDEF)
        local mabbonus = (100 + mab) / (100 + tmdb)
        mabbonus = math.max(0, mabbonus)
        if mabbonus > 0 then
            dmg = math.floor(dmg / mabbonus)
        end
        local mdbbonus = (100 + mdb) / (100 + tmdb)
        mdbbonus = math.max(0, mdbbonus)
        if mdbbonus > 0 then
            dmg = math.floor(dmg * mdbbonus)
        end
    end

    return super(caster, target, spell, dmg * skillMult, params, trickAttackTarget)
end)

-- ensure diffusion benefits from caster's Grapevine cape
m:addOverride('xi.spells.blue.calculateDurationWithDiffusion', function(caster, duration)
    local newDuration = super(caster, duration)

    return newDuration * (1 + caster:getMod(xi.mod.ENH_MAGIC_DURATION) / 100)
end)

return m
