-----------------------------------
-- Activate Afterglow
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("afterglow")

local weapons =
{
    ['death_penalty'] =
    {
        wsId = xi.wsUnlock.LAST_STAND,
        modelId = 107,
        slotId = xi.slot.RANGED,
    },
    ['annihilator'] =
    {
        wsId = xi.wsUnlock.LAST_STAND,
        modelId = 103,
        slotId = xi.slot.RANGED,
    },
    ['yoichinoyumi'] =
    {
        wsId = xi.wsUnlock.APEX_ARROW,
        modelId = 104,
        slotId = xi.slot.RANGED,
    },
    ['terpsichore'] =
    {
        wsId = xi.wsUnlock.EXENTERATOR,
        modelId = 569,
        slotId = xi.slot.MAIN,
    },
    ['tupsimati'] =
    {
        wsId = xi.wsUnlock.SHATTERSOUL,
        modelId = 570,
        slotId = xi.slot.MAIN,
    },
    ['conquerer'] =
    {
        wsId = xi.wsUnlock.UPHEAVAL,
        modelId = 555,
        slotId = xi.slot.MAIN,
    },
    ['glanzfaust'] =
    {
        wsId = xi.wsUnlock.SHIJIN_SPIRAL,
        modelId = 496,
        slotId = xi.slot.MAIN,
    },
    ['yagrush'] =
    {
        wsId = xi.wsUnlock.REALMRAZER,
        modelId = 556,
        slotId = xi.slot.MAIN,
    },
    ['laevateinn'] =
    {
        wsId = xi.wsUnlock.SHATTERSOUL,
        modelId = 557,
        slotId = xi.slot.MAIN,
    },
    ['murgleis'] =
    {
        wsId = xi.wsUnlock.REQUIESCAT,
        modelId = 558,
        slotId = xi.slot.MAIN,
    },
    ['vajra'] =
    {
        wsId = xi.wsUnlock.EXENTERATOR,
        modelId = 559,
        slotId = xi.slot.MAIN,
    },
    ['burtgang'] =
    {
        wsId = xi.wsUnlock.REQUIESCAT,
        modelId = 560,
        slotId = xi.slot.MAIN,
    },
    ['liberator'] =
    {
        wsId = xi.wsUnlock.ENTROPY,
        modelId = 561,
        slotId = xi.slot.MAIN,
    },
    ['aymur'] =
    {
        wsId = xi.wsUnlock.RUINATOR,
        modelId = 562,
        slotId = xi.slot.MAIN,
    },
    ['carnwenhan'] =
    {
        wsId = xi.wsUnlock.EXENTERATOR,
        modelId = 563,
        slotId = xi.slot.MAIN,
    },
    ['gastraphetes'] =
    {
        wsId = xi.wsUnlock.LAST_STAND,
        modelId = 106,
        slotId = xi.slot.RANGED,
    },
    ['kogarasumaru'] =
    {
        wsId = xi.wsUnlock.TACHI_SHOHA,
        modelId = 564,
        slotId = xi.slot.MAIN,
    },
    ['nagi'] =
    {
        wsId = xi.wsUnlock.BLADE_SHUN,
        modelId = 565,
        slotId = xi.slot.MAIN,
    },
    ['ryunohige'] =
    {
        wsId = xi.wsUnlock.STARDIVER,
        modelId = 566,
        slotId = xi.slot.MAIN,
    },
    ['nirvana'] =
    {
        wsId = xi.wsUnlock.SHATTERSOUL,
        modelId = 567,
        slotId = xi.slot.MAIN,
    },
    ['tizona'] =
    {
        wsId = xi.wsUnlock.REQUIESCAT,
        modelId = 568,
        slotId = xi.slot.MAIN,
    },
    ['death_penalty'] =
    {
        wsId = xi.wsUnlock.LAST_STAND,
        modelId = 107,
        slotId = xi.slot.RANGED,
    },
    ['kenkonken'] =
    {
        wsId = xi.wsUnlock.SHIJIN_SPIRAL,
        modelId = 495,
        slotId = xi.slot.MAIN,
    },
    ['spharai'] =
    {
        wsId = xi.wsUnlock.SHIJIN_SPIRAL,
        modelId = 497,
        slotId = xi.slot.MAIN,
    },
    ['mandau'] =
    {
        wsId = xi.wsUnlock.EXENTERATOR,
        modelId = 544,
        slotId = xi.slot.MAIN,
    },
    ['excalibur'] =
    {
        wsId = xi.wsUnlock.REQUIESCAT,
        modelId = 545,
        slotId = xi.slot.MAIN,
    },
    ['ragnarok'] =
    {
        wsId = xi.wsUnlock.RESOLUTION,
        modelId = 546,
        slotId = xi.slot.MAIN,
    },
    ['guttler'] =
    {
        wsId = xi.wsUnlock.RUINATOR,
        modelId = 547,
        slotId = xi.slot.MAIN,
    },
    ['bravura'] =
    {
        wsId = xi.wsUnlock.UPHEAVAL,
        modelId = 548,
        slotId = xi.slot.MAIN,
    },
    ['gungnir'] =
    {
        wsId = xi.wsUnlock.STARDIVER,
        modelId = 549,
        slotId = xi.slot.MAIN,
    },
    ['apocalypse'] =
    {
        wsId = xi.wsUnlock.ENTROPY,
        modelId = 550,
        slotId = xi.slot.MAIN,
    },
    ['kikoku'] =
    {
        wsId = xi.wsUnlock.BLADE_SHUN,
        modelId = 551,
        slotId = xi.slot.MAIN,
    },
    ['amanomurakumo'] =
    {
        wsId = xi.wsUnlock.TACHI_SHOHA,
        modelId = 552,
        slotId = xi.slot.MAIN,
    },
    ['mjollnir'] =
    {
        wsId = xi.wsUnlock.REALMRAZER,
        modelId = 553,
        slotId = xi.slot.MAIN,
    },
    ['claustrum'] =
    {
        wsId = xi.wsUnlock.SHATTERSOUL,
        modelId = 554,
        slotId = xi.slot.MAIN,
    },
}

for weapon, weaponData in pairs(weapons) do
    local weapPath = string.format('xi.items.%s', weapon)
    local weapEquipPath = string.format('%s.onItemEquip', weapPath)
    local dummyPath = string.format('%s.dummyPath', weapPath)

    xi.module.ensureTable(dummyPath) -- trick to ensure item table without overwriting anything
    -- NOTE: any magian item has onItemEquip/Unequip functions hardcoded in magian.lua.
    -- This will respect that but also don't go crazy trying to put those functions in a base item lua file, they get overwritten
    -- NOTE2: scripts/items are loaded AFTER modules using sol::update_if_empty so... yea
    -- TL;DR this works to call super from magian or other modules, but any base item luas for these weapons will be ignored
    -- At the time of writing this code, there were no relevant weapon lua files (the ranged ones have ilvl onItemUse functions)


    m:addOverride(weapEquipPath, function(player, item)
        super(player, item)

        if
            item:getID() == player:getEquipID(weaponData.slotId) and
            player:hasLearnedWeaponskill(weaponData.wsId)
        then
            printf("Applying afterglow for %s...", player:getName())
            player:setModelId(weaponData.modelId, weaponData.slotId)
        end
    end)
end

return m
