------------------------------------
--------- Halloween Event ----------
------------------------------------
local m = Module:new("halloween_event")

local rewards =
{
    { "Candy ring",          5621,  50 },
    { "Pitchfork +1",       18103, 100 },
    { "Trick Staff II",     17588, 100 },
    { "Pumpkin Head II",    15176,  50 },

    { "Spectral Chair",     10065, 300, { wew = false, cw = false } },
    { "Iron Giant",         10079, 300, { wew = false, cw = false } },
    { "Coven hat",          16076,  30 },
    { "Kakai cap +1",       25587, 100 },

    { "Malice masher +1",   21154, 100 },
    { "Cotton candy",        5709,  40 },
    { "Jack-o'-pricket",     3622,  20 },
    { "Mandragora pricket",  3646,  20 },

    { "Ominaeshi Yukata",    11319, 60, { gender = 0 } },
    { "Onnagimi Yukata",     14535, 60, { gender = 0 } },

    { "Otokoeshi Yukata",    11318, 60, { gender = 1 } },
    { "Otokogimi Yukata",    14534, 60, { gender = 1 } },

    { "Volant Serum",         5350, 40 },
    { "Pungent Powder III",   6537, 40 },

    { "Osseous Serum",       3489,  40 },
    { "Little Lugworm",      5118,  40 },
    { "Ark Shield",         26490, 200 },
    { "Cipher: Ullegore",   10178, 500, { wew = false, cw = true } },
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function completeTransaction(player, npc, item)
    local slimeBalance = player:getCharVar("slimeBalance")
    delaySendMenu(player, {
        title = fmt("Spend {} slimes? ({} available)", item[3], slimeBalance),
        options =
        {
            {
                "Yes, I'm sure!",
                function(playerArg)
                    if slimeBalance < item[3] then
                        player:fmt("You do not have enough stored slimes.")
                        return
                    end

                    if npcUtil.giveItem(player, item[2]) then
                        player:setCharVar("slimeBalance", slimeBalance - item[3])
                    end
                end,
            },
            {
                "No, I change my mind.",
                function()
                end,
            },
        },
    })
end

local selbinaDecorations =
{
    {  293,  19.27, -14.56, 83.35, 154 }, -- rightdoorslime
    {  293,  16.34, -14.56, 83.37,  65 }, -- leftdoorslime
    { 1293,  24.90, -14.68, 56.22,  58 }, -- rightballoon
    { 1287,  15.54, -14.56, 57.17,  65 }, -- leftballoon
    { 1300,  34.80,  -6.56, -0.24,  29 }, -- orangetent
    { 2142, -13.18, -11.76,  7.34,  64 }, -- leftportalroof
    { 2139,  14.34, -11.76,  7.99, 255 }, -- rightportalroof
}

local entities = {}

entities.Selbina = {
    {
        objtype   = xi.objType.NPC,
        name      = "Balamor",
        look      = 3099,
        x         = 9.67,
        y         = -14.56,
        z         = 66.21,
        rotation  = 254,

        onTrigger = function(player, npc)
            cexi.util.dialog(player, {
                "Psst... Hey, you! Want to play a game?! Trade me 1,000 gil to get started!",
            }, npc:getPacketName(), { npc = npc })
        end,

        onTrade   = function(player, npc, trade)
            if not npcUtil.tradeHasExactly(trade, { { "gil", 1000 } }) then
                cexi.util.dialog(player, {
                    "Scram! I don't have time for your tom-foolery!",
                }, npc:getPacketName(), { npc = npc })
                return
            end

            delaySendMenu(player, {
                title = string.format("Test your luck?"),
                options =
                {
                    {
                        "Yes, I'm sure!",
                        function(playerArg)
                            player:tradeComplete()

                            local gobbieRoll = math.random(1,999)
                            local playerRoll = math.random(1,999)

                            player:timer(2000, function(playerArg)
                                player:printToPlayer("Let's make a bet, whoever rolls the higher number, wins a special surprise!", 0, npc:getPacketName())                 
                            end)

                            player:timer(4000, function(playerArg)
                                player:printToPlayer(string.format("%s rolls a %s.", npc:getPacketName(), gobbieRoll), xi.msg.channel.SYSTEM_3)
                            end)

                            player:timer(6000, function(playerArg)
                                player:printToPlayer("Ok, now it's your turn!", 0, npc:getPacketName())
                            end)

                            player:timer(8000, function(playerArg)
                                -- player:printToPlayer("DEBUG")
                                player:printToPlayer(string.format("%s rolls a %s.", player:getName(), playerRoll), xi.msg.channel.SYSTEM_3)
                            end)

                            player:timer(10000, function(playerArg)
                                if gobbieRoll > playerRoll then
                                    player:printToPlayer("Na-na-na poo-poo! I win! You lose! Better luck next time... Loser!", 0, npc:getPacketName())
                                    return
                                else
                                    player:printToPlayer("Whaaaat?! How could this be??? Go on.. Get outta my sight!", 0, npc:getPacketName())
                                    player:timer(1000, function(playerArg)
                                        player:printToPlayer("Balamor boots you into the abyss...", xi.msg.channel.SYSTEM_3)
                                    end)

                                    player:timer(4000, function(playerArg)
                                        player:setPos(-500, -30, 528, 63, 293)
                                    end)
                                end
                            end)
                        end,
                    },
                    {
                        "No, I change my mind.",
                        function(playerArg)
                        end,
                    },
                },
            })
        end,
    },
}

for _, selbinaDecoration in pairs(selbinaDecorations) do
    table.insert(entities.Selbina, {
        objtype      = xi.objType.NPC,
        name         = " ",
        look         = selbinaDecoration[1],
        x            = selbinaDecoration[2],
        y            = selbinaDecoration[3],
        z            = selbinaDecoration[4],
        rotation     = selbinaDecoration[5],
        untargetable = true,
    })
end

local sanctoriumDecorations =
{
    { 3105, -503.51, -30.75, 518.43, 249 }, -- rightSlave
    { 3105, -496.83, -30.75, 518.64, 131 }, -- leftSlave
    { 2143, -499.67, -30.34,  482.2, 199 }, -- backPortal
    {   15, -484.42, -30.75, 510.56,  99 }, -- leftDark
    {   15, -515.71, -30.75, 510.22,  40 }, -- rightDark
    {  263,  -493.4, -30.34, 491.43, 200 }, -- redBatstriple
    {  256, -506.95, -30.34,  509.9, 232 }, -- blackBatsOne
    {  256, -492.24, -30.34, 506.77, 159 }, -- blackBatsTwo
    { 2277, -500.82, -30.34, 494.99, 188, "Haudrale" }, -- haudrale
    { 2278, -498.17, -30.34, 497.43, 187, "Aquila"   }, -- aquila
    { 2299, -502.36, -30.34, 497.82, 203, "Larzos"   }, -- larzos
    {   26, -515.61, -30.34, 493.98, 215, "Odin"     }, -- odin
}

entities.Reisenjima_Sanctorium = {
    {
        objtype  = xi.objType.NPC,
        name     = "Lady Lilith",
        look     = 2400,
        x        = -500,
        y        = -30.340,
        z        = 500,
        rotation = 192,

        onTrigger = function(player, npc)
            player:printToPlayer("So, you wish to travel through the unknown?", 0, npc:getPacketName())

            delaySendMenu(player, {
                title   = "How do you respond?",
                options =
                {
                    {
                        "Take me away!",
                        function()
                            cexi.util.dialog(player, {
                                "Very well, my dear... You'll need to collect slimes from Castle Zvahl!",
                                "1...",
                                "2...",
                                "3...",
                                { pos = { 384.61, -12, -19.729, 128, 161 } },
                            }, npc:getPacketName(), { npc = npc })
                        end,
                    },
                    {
                        "Run away!",
                        function()
                        end,
                    },
                },
            })
        end,
    },
    {
        objtype = xi.objType.NPC,
        name     = "Decrepit S.Lord",
        look     = 1427,
        x        = -485.56,
        y        = -30.34,
        z        = 497.33,
        rotation = 132,

        onTrade = function(player, npc, trade)
            local count        = trade:getItemCount()
            local slimeBalance = player:getCharVar("slimeBalance")

            -- store slimes
            if trade:hasItemQty(8759, count) then
                player:tradeComplete()
                player:setCharVar("slimeBalance", slimeBalance + count)

                cexi.util.dialog(player, {
                    fmt("You have {} metal slimes available to spend. Choose wisely.", slimeBalance + count)
                }, npc:getPacketName(), { npc = npc })
            end
        end,

        onTrigger = function(player, npc)
            local slimeBalance = player:getCharVar("slimeBalance")

            cexi.util.dialog(player, {
                fmt("You have {} metal slimes available to spend. Choose wisely.", slimeBalance)
            }, npc:getPacketName(), { npc = npc })

            local wares  = {}
            local isCW   = player:isCrystalWarrior()
            local isWEW  = player:isClassicMode()
            local gender = player:getGender()

            for _, rewardInfo in pairs(rewards) do
                if rewardInfo[4] == nil then
                    table.insert(wares, rewardInfo)
                else
                    if rewardInfo[4].gender ~= nil then
                        if gender == rewardInfo[4].gender then
                            table.insert(wares, rewardInfo)
                        end
                    else
                        if isCW then
                            if
                                rewardInfo[4].cw == nil or
                                rewardInfo[4].cw
                            then
                                table.insert(wares, rewardInfo)
                            end
                        elseif isWEW then
                            if
                                rewardInfo[4].wew == nil or
                                rewardInfo[4].wew
                            then
                                table.insert(wares, rewardInfo)
                            end
                        else
                            table.insert(wares, rewardInfo)
                        end
                    end
                end
            end

            cexi.util.simpleShop(player, npc, wares, completeTransaction, fmt("Choose a reward ({}):", slimeBalance))
        end,
    },
}

for _, sanctoriumDecoration in pairs(sanctoriumDecorations) do
    table.insert(entities.Reisenjima_Sanctorium, {
        objtype      = xi.objType.NPC,
        name         = sanctoriumDecoration[6] or " ",
        look         = sanctoriumDecoration[1],
        x            = sanctoriumDecoration[2],
        y            = sanctoriumDecoration[3],
        z            = sanctoriumDecoration[4],
        rotation     = sanctoriumDecoration[5],
        untargetable = true,
    })
end

entities.Castle_Zvahl_Baileys = {
    {
        objtype = xi.objType.NPC,
        name    = " ",
        look    = 721,
        x       = 384.61,
        y       = -12,
        z       = -19.729,

        onTrigger = function(player, npc)
            delaySendMenu(player, {
                title   = "Return to Lady Lilth?",
                options =
                {
                    {
                        "Take me away!",
                        function(playerArg)
                            player:fmt("Hang tight...")

                            player:timer(1000, function(playerArg)
                                player:setPos(-500, -30, 528, 63, 293)
                            end)

                        end,
                    },
                    {
                        "Run away!",
                        function()
                        end,
                    },
                },
            })
        end,
    },
}

cexi.util.liveReload(m, entities)

return m
