-----------------------------------
-- Provide additional things to signet effect
-----------------------------------
require("modules/module_utils")
-----------------------------------

local m = Module:new("signet_effect")

local listenerName = 'cp_in_sea'

m:addOverride('xi.effects.signet.onEffectGain', function(target, effect)
    -- give conquest points for xp gained in sea
    if
        target:getObjType() == xi.objType.PC and
        target:getCurrentRegion() == xi.region.LUMORIA
    then
        target:addListener('EXPERIENCE_POINTS', listenerName, function(player, mob, exp)
            local cpGained = 0.10 * exp
            local playerNation = player:getNation()
            
            if playerNation == 0 then
                player:addCurrency('sandoria_cp', cpGained)
            elseif playerNation == 1 then
                player:addCurrency('bastok_cp', cpGained)
            elseif playerNation == 2 then
                player:addCurrency('windurst_cp', cpGained)
            end
        end)
    end

    super(target, effect)
end)

m:addOverride('xi.effects.signet.onEffectLose', function(target, effect)
    if target:getObjType() == xi.objType.PC then
        target:removeListener(listenerName)
    end

    super(target, effect)
end)

return m
