require('modules/module_utils')
-----------------------------------

local m = Module:new('aftermath')

-- Tier 1 Mythic 29 to 33
for i = 29, 33 do
    -- append tp tier into higher tp tiers (so you get cumulative buffs at any tier)
    for tier = 3, 1, -1 do
        for prevTier = 1, tier do
            if tier > prevTier then
                for _, modEntry in ipairs(xi.aftermath.effects[i].mods[prevTier]) do
                    table.insert(xi.aftermath.effects[i].mods[tier], modEntry)
                end
            end
        end
    end
end

-- give mythic AM tier based on 1.5x TP (so AM3 at 2000 TP)
-- duration will still be based on original TP
local tpMultiplier = 1.5

m:addOverride('xi.effects.aftermath.onEffectGain', function(target, effect)
    -- mythic aftermath
    if effect:getTier() == 2 then
        local newTP = math.min(effect:getSubPower() * tpMultiplier, 3000)
        local newTier = math.floor(newTP / 1000)
        -- icon is set in xi.effect['AFTERMATH_LV'..tier], but all the rest is calculated in onEffectGain, so just shortcircuit the icon for simplicity
        effect:setIcon(xi.effect['AFTERMATH_LV'..newTier])
        -- subpower defines which bonuses mythic AM gets
        effect:setSubPower(newTP)
    end

    super(target, effect)
end)

m:addOverride('xi.aftermath.canOverwrite', function(player, tp, aftermathId, aftermathType)
    -- don't overwrite original tp
    local newTP = tp
    -- mythic aftermath
    if aftermathType == 2 then
        newTP = tp * tpMultiplier
    end

    return super(player, math.min(newTP, 3000), aftermathId, aftermathType)
end)

return m
