-----------------------------------
-- !ventures
-- View the current list of active ventures
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = ''
}

local settings =
{
    -- Server Vars
    resetVar  = "[VENTURE]RESET",
    rollVar   = "[VENTURE]EXP_%u",
    dynaVar   = "[VENTURE]DYNAMIS_%u",
    fishVar   = "[VENTURE]FISHING_%u",
    helmVar   = "[VENTURE]%s_%u",
}

local helmTypes =
{
    "Harvesting",
    "Excavation",
    "Logging",
    "Mining",
}

local helmTiers =
{
    "(Low)",
    "(Mid)",
    "(High)",
}

commandObj.onTrigger = function(player)
    player:sys("=== Today's Goblin Ventures ===")
    -----------------------------------
    -- EXP Areas
    -----------------------------------
    local str = ""

    for rangeIndex = 1, 3 do
        local expRoll  = GetServerVariable(string.format(cexi.ventures.exp.rollVar, rangeIndex))
        local areaName = string.gsub(cexi.ventures.exp.ventures[rangeIndex][expRoll].area, "_", " ")

        if player:getCharVar("[VENTURE]EXP_CURRENT") == cexi.ventures.exp.ventures[rangeIndex][expRoll].index then
            str = fmt(
                "{}{} {} [{}/{}], ",
                str,
                cexi.ventures.exp.categories[rangeIndex][1],
                areaName, player:getCharVar("[VENTURE]EXP_PROGRESS"),
                cexi.ventures.exp.ventures[rangeIndex][expRoll].qty
            )
        else
            str = string.format("%s%s %s, ", str, cexi.ventures.exp.categories[rangeIndex][1], areaName)
        end
    end

    player:fmt("EXP Areas: {}", str)

    str = ""

    for rangeIndex = 4, 6 do
        local expRoll = GetServerVariable(string.format(cexi.ventures.exp.rollVar, rangeIndex))
        local areaName = string.gsub(cexi.ventures.exp.ventures[rangeIndex][expRoll].area, "_", " ")

        if player:getCharVar("[VENTURE]EXP_CURRENT") == cexi.ventures.exp.ventures[rangeIndex][expRoll].index then
            str = fmt(
                "{}{} {} [{}/{}], ",
                str,
                cexi.ventures.exp.categories[rangeIndex][1],
                areaName,
                player:getCharVar("[VENTURE]EXP_PROGRESS"),
                cexi.ventures.exp.ventures[rangeIndex][expRoll].qty
            )
        else
            str = string.format("%s %s %s", str, cexi.ventures.exp.categories[rangeIndex][1], areaName)
        end

        if rangeIndex < 6 then
            str = str .. ","
        end
    end

    player:fmt(str)

    -----------------------------------
    -- Dynamis
    -----------------------------------
    if player:isCrystalWarrior() then
        local dynaRoll = GetServerVariable(string.format(cexi.ventures.dynamis.rollVar, 1))

        if player:getCharVar("[VENTURE]DYNAMIS_CURRENT") == cexi.ventures.dynamis.ventures[1][dynaRoll].index then
            player:fmt(
               "Dynamis: (Cities) {} [{}/{}]",
                cexi.ventures.dynamis.ventures[1][dynaRoll].area,
                player:getCharVar("[VENTURE]DYNAMIS_PROGRESS"),
                cexi.ventures.dynamis.ventures[1][dynaRoll].qty
            )
        else
            player:fmt("Dynamis: (Cities) {}", cexi.ventures.dynamis.ventures[1][dynaRoll].area)
        end
    end

    -----------------------------------
    -- Fishing
    -----------------------------------
    str = ""

    for rangeIndex = 1, 3 do
        local fishRoll = GetServerVariable(string.format(cexi.ventures.fishing.rollVar, rangeIndex))
        local fishName = cexi.ventures.fishing.ventures[rangeIndex].list[fishRoll][2]

        if player:getCharVar("[VENTURE]FISHING_CURRENT") == cexi.ventures.fishing.ventures[rangeIndex].list[fishRoll][4] then
            str = fmt(
               "{}{} {} [{}/{}], ",
                str,
                cexi.ventures.fishing.ventures[rangeIndex].name,
                fishName,
                player:getCharVar("[VENTURE]FISHING_PROGRESS"),
                cexi.ventures.fishing.ventures[rangeIndex].list[fishRoll][3]
            )
        else
            str = string.format("%s%s %s, ", str, cexi.ventures.fishing.ventures[rangeIndex].name, fishName)
        end
    end

    player:fmt("Fishing: {}", str)

    str = ""

    for rangeIndex = 4, 6 do
        local fishRoll = GetServerVariable(string.format(cexi.ventures.fishing.rollVar, rangeIndex))
        local fishName = cexi.ventures.fishing.ventures[rangeIndex].list[fishRoll][2]

        if player:getCharVar("[VENTURE]FISHING_CURRENT") == cexi.ventures.fishing.ventures[rangeIndex].list[fishRoll][4] then
            str = fmt(
               "{}{} {} [{}/{}]",
                str,
                cexi.ventures.fishing.ventures[rangeIndex].name,
                fishName,
                player:getCharVar("[VENTURE]FISHING_PROGRESS"),
                cexi.ventures.fishing.ventures[rangeIndex].list[fishRoll][3]
            )
        else
            str = string.format("%s %s %s", str, cexi.ventures.fishing.ventures[rangeIndex].name, fishName)
        end

        if rangeIndex < 6 then
            str = str .. ","
        end
    end

    player:fmt(str)

    -----------------------------------
    -- HELM
    -----------------------------------
    for _, helmType in pairs(helmTypes) do
        str = ""

        for tierIndex, tierName in pairs(helmTiers) do
            local helmName = string.lower(helmType)
            local helmRoll = GetServerVariable(string.format(cexi.ventures[helmName].rollVar, tierIndex))
            local areaName = cexi.ventures[helmName].ventures[tierIndex].list[helmRoll][1]

            local path = fmt("[VENTURE]{}", string.upper(helmType))

            if player:getCharVar(path .. "_CURRENT") == cexi.ventures[helmName].ventures[tierIndex].list[helmRoll][3] then
                str = fmt(
                   "{}{} {} [{}/{}]",
                    str,
                    tierName,
                    string.gsub(areaName, "_", " "),
                    player:getCharVar(path .. "_PROGRESS"),
                    cexi.ventures[helmName].ventures[tierIndex].qty
                )
            else
                str = string.format("%s%s %s", str, tierName, string.gsub(areaName, "_", " "))
            end

            if tierIndex < 3 then
                str = str .. ", "
            end
        end

        player:fmt("{}: {}", helmType, str)
    end
end

return commandObj
