----------------------------------
-- func: !trials
-- desc: List progress on custom quest trials
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = ""
}

local function getNoviceRange(player, trial, current, low, high)
    local str = ""

    for mobIndex = low, high do
        local mobInfo = trial.mobs[mobIndex]

        if mobInfo ~= nil then
            local progress = player:getCharVar(string.format("[CQ]NOVICE_%u_%u", current, mobIndex))
            local total    = mobInfo[3]
            local mobName  = string.gsub(mobInfo[1], "_", " ")
            local mobArea  = string.gsub(mobInfo[2], "_", " ")

            str = str .. string.format("%s (%s) %u/%u, ", mobName, mobArea, progress, total)
        end
    end

    return str
end

local function printNoviceTrials(player)
    local current  = player:getCharVar("[CQ]NOVICE_ITEM")

    if current == 0 then
        player:fmt("Novice Trial: No current trial")
    else
        local trial = cexi.trials.novice.list[current]
        local str   = string.format("Novice Trial [%s]: ", trial.name)
        str = str .. getNoviceRange(player, trial, current, 1, 3)
        player:fmt(str)

        if #trial.mobs > 3 then
            str = getNoviceRange(player, trial, current, 4, 7)
            player:fmt(str)
        end
    end
end

commandObj.onTrigger = function(player, arg)
    printNoviceTrials(player)
end

return commandObj
