-----------------------------------
-- func: skills
-- desc: Lists a player's custom skills
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = ""
}

commandObj.onTrigger = function(player)
    local result = {}

    for _, skillInfo in pairs(cexi.skill) do
        if type(skillInfo) == "table" then
            local realLevel  = player:getCharVar(skillInfo.varSkill)

            if realLevel > 0 then
                local skillLevel = realLevel / 10
                local skillRank  = skillInfo.ranks[math.floor(skillLevel / 10) + 1]

                table.insert(result, string.format("%s: %.1f (%s)", skillInfo.name, skillLevel, skillRank[2]))
            end
        end
    end

    if #result == 0 then
        player:fmt("You currently possess no special skills.")
    else
        player:sys("=== {}'s current skills ===", player:getName())

        for _, skillText in pairs(result) do
            player:fmt(skillText)
        end
    end
end

return commandObj
