-----------------------------------
-- func: signet
-- desc: Casts signet on the player.
-----------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = "is"
}

commandObj.onTrigger = function(player)
    if
        player:isCrystalWarrior() or
        player:isClassicMode()
    then
        player:printToPlayer("Your character type cannot use this command.", xi.msg.channel.SYSTEM_3)
        return
    end

    player:printToPlayer("Enjoy signet!")
    player:delStatusEffectsByFlag(xi.effectFlag.INFLUENCE, true)
    player:addStatusEffect(xi.effect.SIGNET, 0, 0, 15000)
end

return commandObj
