----------------------------------
-- func: !scroll (item name or ID)
-- desc: Check if scroll is currently stored
-----------------------------------
local commandObj = {}
local tradeable  = cexi.crystal_warrior.scrolls_tradeable

commandObj.cmdprops =
{
    permission = 0,
    parameters = "s"
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!scroll (item name or ID)")
end

commandObj.onTrigger = function(player, arg)
    -- Block command if player is not CW or hasn't completed quest
    if
        not player:isCrystalWarrior() or
        player:getCharVar("[CW]DECRYPTING_ANTIQUITY") < 5
    then
        return
    end

    local itemID = tonumber(arg)

    if itemID == nil then
        local str = string.gsub(string.lower(arg), " ", "_")
        itemID = GetItemIDByName(str)
    end

    local itemInfo = cexi.crystal_warrior.scrolls_tradeable[itemID]

    if itemInfo == nil then
        player:sys("That item isn't recognized.")
        return
    end

    local index     = itemInfo[1]
    local itemName  = itemInfo[2]
    local category  = itemInfo[3]
    local shortened = cexi.crystal_warrior.scrolls_short[category]
    local numeral   = cexi.numeral[itemInfo[4]]
    local varName   = fmt("[CW]SCROLL_{}_{}", shortened, numeral)
    local value    = player:getCharVar(varName)

    if utils.mask.getBit(value, index) then
        player:fmt("You have a scroll of {} currently in storage ({} \129\168 {})", itemName, category, numeral)
        return
    else
        player:fmt("You do not have a scroll of {} in storage.", itemName)
    end
end

return commandObj
