-----------------------------------
-- func: sanction
-- desc: Casts sanction on the player.
-----------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = "is"
}

commandObj.onTrigger = function(player)
    if
        player:isCrystalWarrior() or
        player:isClassicMode()
    then
        player:printToPlayer("Your character type cannot use this command.", xi.msg.channel.SYSTEM_3)
        return
    end

    player:printToPlayer("Enjoy sanction!")
    player:delStatusEffectsByFlag(xi.effectFlag.INFLUENCE, true)
    player:addStatusEffect(xi.effect.SANCTION, 0, 0, 15000)
end

return commandObj
