----------------------------------
-- func: !prestige
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = ""
}

commandObj.onTrigger = function(player, arg)
    if
        not player:isCrystalWarrior() or
        player:getCharVar("[CW]MASTER") == 0
    then
        return
    end

    local listedAny = false
    player:sys("=== Prestige Bonuses ===")

    for jobID = xi.job.WAR, xi.job.RUN do
        if cexi.prestige[jobID] ~= nil then
            local tier = player:getCharVar(fmt("[CW]PRESTIGE_{}", xi.jobNames[jobID][1]))

            if tier > 0 then
                player:sys(
                    "{}: {}{} ({})",
                    xi.jobNames[jobID][2],
                    string.rep("\129\154", tier),
                    string.rep("\129\153", 5 - tier),
                    cexi.prestigeDesc(jobID, tier)
                )

                listedAny = true
            end
        end
    end

    if not listedAny then
        player:sys("<None>")
    end
end

return commandObj
