----------------------------------
-- func: !points
-- desc: List custom points
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = ""
}

local points =
{
    { "CatsEyeXI", {
        { "Obs. Frag.",      { currency = "obsidian_fragment" } },
        { "Domain Shards",   "[Domain]Shards"                   },
        { "Dynamis RP",      "[NEO]RP_BALANCE"                  },
        { "Doubloons",       "[FISHING]DOUBLOONS"               },
        { "Garrison Pts.",   "[GARRISON]POINTS"                 },
        { "DKP",             "[DS]POINTS"                       },
        { "Scraps",          "[CQ]GOBLIN_SCRAPS"                },
    }},
    { "Ventures", {
        { "EXP",             "[VENTURE]EXP_POINTS"              },
        { "Fishing",         "[VENTURE]FISHING_POINTS"          },
        { "Dynamis",         "[VENTURE]DYNAMIS_POINTS"          },
        { "Harvesting",      "[VENTURE]HARVESTING_POINTS"       },
        { "Excavation",      "[VENTURE]EXCAVATION_POINTS"       },
        { "Logging",         "[VENTURE]LOGGING_POINTS"          },
        { "Mining",          "[VENTURE]MINING_POINTS"           },
        { "Battle",          "[VENTURE]BATTLE_POINTS"           },
    }},
    { "Events", {
        { "Clamming",        "[CLAMMING]Credits"                },
    }},
    { "Crystal Warrior", {
        { "Arena Points",    "[CW]ARENA_POINTS"                 },
        { "Tonberry Tokens", "[CW]TONBERRY_TOKENS"              },
        { "Gobbie Grandeur", "[CW]GAMBIT_GG"                    },
        { "Helper Points",   "[HELPER]POINTS"                   },
    }, "CW" },
}

commandObj.onTrigger = function(player, arg)
    for _, info in pairs(points) do
        if
            info[3] == nil or
            player:isCrystalWarrior()
        then
            if type(info[2]) == "table" then
                local count = 0
                local out   = info[1]

                for _, subInfo in pairs(info[2]) do
                    local value = 0

                    if type(subInfo[2]) == "table" then
                        value = player:getCurrency(subInfo[2].currency)
                    else
                        value = player:getCharVar(subInfo[2])
                    end

                    if value > 0 then
                        if count == 0 then
                            out = fmt("{}: {} ({})", out, subInfo[1], value)
                        else
                            out = fmt("{} / {} ({})", out, subInfo[1], value)
                        end

                        count = count + 1
                    end
                end

                if count > 0 then
                    player:fmt(out)
                end
            else
                local value = 0

                if type(subInfo[2]) == "table" then
                    value = player:getCurrency(info[2].currency)
                else
                    value = player:getCharVar(info[2])
                end

                if value > 0 then
                    player:fmt("{}: {}", info[1], value)
                end
            end
        end
    end
end

return commandObj
