-----------------------------------
-- func: pf
-- desc: Returns a list of all players who are seeking a group.
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = "s"
}

local charTypes =
{
    [0] = 'ACE',
    [1] = 'CW',
    [2] = 'WEW',
}

commandObj.onTrigger = function(player, arg)
    local seekers = GetPlayersLFG()
    local currentTime = os.time()

    if arg == nil then
        for _, seeker in pairs(seekers) do
            local charType = charTypes[seeker.charType]
            local zoneName = string.gsub(seeker.zoneName, '_', ' ')
            local jobs     = xi.jobNames[seeker.mJob][1]

            player:printToPlayer(string.format("Name: %s | GameMode: %s | Job: %s | Level: %i | Zone: %s | Type: %u | Comment: %s", seeker.playerName, charType, jobs, seeker.mJobLvl, zoneName, seeker.type, seeker.comment), xi.msg.channel.SYSTEM_3)
        end
    elseif arg == "register" then
        local mJob = xi.jobNames[player:getMainJob()][1] .. player:getMainLvl()

        player:setCharVar('[LFG]SeekTime', currentTime, currentTime + 7200) -- expire after two hours
        player:setCharVar('[LFG]Job', player:getMainJob(), currentTime + 7200)
        player:setCharVar('[LFG]Level', player:getMainLvl(), currentTime + 7200)
        player:printToPlayer(string.format('You have registered in the party finder as a %s.', mJob), xi.msg.channel.SYSTEM_3)
    elseif arg == "remove" then
        player:setCharVar('[LFG]SeekTime', 0)
        player:printToPlayer('Your registration has been removed from party finder.', xi.msg.channel.SYSTEM_3)
    end
end

return commandObj
