----------------------------------
-- func: !pass
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = ""
}

commandObj.onTrigger = function(player, arg)
    if not player:hasItem(xi.item.GARRISON_PASS) then
        player:sys("You have not yet obtained any relevant passes.")
        return
    end

    local current = player:getCharVar("[GARRISON]PASS")
    local result  = {}

    for index, itemInfo in pairs(cexi.bundle.garrison) do
        if utils.mask.getBit(current, index) then
            table.insert(result, itemInfo.name)
        end
    end

    player:fmt("Your current passes:")

    if #result == 0 then
        player:fmt("Garrison Pass: <Empty>")
    else
        player:fmt("Garrison: {}", cexi.util.printList(result))
    end
end

return commandObj
