----------------------------------
-- func: !keys
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = ""
}

local function getKeyList(player, varName, bundle)
    local current = player:getCharVar(varName)
    local result  = {}

    for index, itemInfo in pairs(bundle) do
        if utils.mask.getBit(current, index) then
            table.insert(result, itemInfo.name)
        end
    end

    return result
end

local function printKeyList(player, listName, keyList)
    if #keyList == 0 then
        player:fmt("{}: <Empty>", listName)
    else
        player:fmt("{}: {}", listName, cexi.util.printList(keyList))
    end
end

commandObj.onTrigger = function(player, arg)
    if not player:isCrystalWarrior() then
        return
    end

    if not player:hasItem(xi.item.GOBLIN_KEYRING) then
        player:sys("You have not yet obtained a keyring.")
        return
    end

    local chest  = getKeyList(player, "[KEYS]CHEST", cexi.bundle.chest)
    local coffer = getKeyList(player, "[KEYS]COFFER", cexi.bundle.coffer)

    player:fmt("Your current keys:")

    printKeyList(player, "Chest", chest)
    printKeyList(player, "Coffer", coffer)
end

return commandObj
