-----------------------------------
-- func: !npc
-- desc: Test dynamic entity before its placed into a module for testing.
-- note: Will spawn after you move from your current position
-----------------------------------
-----------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = ""
}

commandObj.onTrigger = function(player)
    local tabs = player:getCurrency("valor_point")
    local zone = player:getZone()

    local menu =
    {
        title = "Accept Buffs?",
        onStart = function(playerArg)
            -- NOTE: This could be used to lock the player in place
            playerArg:printToPlayer("Would you like a \"Helping Hand\" for 5,000 tabs? ", xi.msg.channel.NS_SAY)
        end,
        options =
        {
            {
                "Yes",
                function(playerArg)
                    if tabs > 5000 then 
                        player:setCurrency("valor_point", tabs - 5000)
                        playerArg:printToPlayer("Enjoy your buffs!", xi.msg.channel.NS_SAY)
                        player:addStatusEffect(xi.effect.REGAIN, 5, 0, 7200)
                        player:addStatusEffect(xi.effect.REGEN, 5, 0, 7200)
                        player:addStatusEffect(xi.effect.REFRESH, 5, 0, 7200)
                        player:addStatusEffect(xi.effect.HASTE, 5, 0, 7200)
                    else
                        playerArg:printToPlayer("You do not possess enough tabs.", xi.msg.channel.NS_SAY)
                    end
                end,
            },
            {
                "No",
                function(playerArg)
                    playerArg:printToPlayer("You can always come back if you need a little boost!", xi.msg.channel.NS_SAY)
                end,
            },
        },
        onCancelled = function(playerArg)
        end,
        onEnd = function(playerArg)
        end,
    }
    
	player:customMenu(menu)
    player:printToPlayer(string.format("You currently have %i tabs available.", tabs), xi.msg.channel.NS_SAY)
end

return commandObj
