-----------------------------------
-- func: help
-- List player commands
-----------------------------------
require('scripts/globals/utils')
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = ''
}

local ACE = 0
local CW  = 1
local WEW = 2

local cmd =
{
    { "!box",           { CW }           },
    { "!chef",          { ACE, WEW }     },
    { "!currency",      { ACE, CW, WEW } },
    { "!dailykills",    { ACE, WEW }     },
    { "!delexp",        { ACE, CW, WEW } },
    { "!essences",      { ACE, CW, WEW } },
    { "!fatigue",       { ACE, WEW }     },
    { "!help",          { ACE, CW, WEW } },
    { "!keys",          { CW }           },
    { "!mog",           { ACE, WEW }     },
    { "!newadventurer", { ACE, CW, WEW } },
    { "!pass",          { ACE, CW, WEW } },
    { "!pf",            { ACE, CW, WEW } },
    { "!points",        { ACE, CW, WEW } },
--    { "!present",       { ACE, CW, WEW } },
    { "!re",            { ACE, CW, WEW } },
    { "!sanction",      { ACE }          },
    { "!scroll",        { CW }           },
    { "!sigil",         { ACE }          },
    { "!signet",        { ACE }          },
    { "!skills",        { ACE, CW, WEW } },
    { "!skipfloor",     { ACE, CW, WEW } },
    { "!trials",        { ACE, CW, WEW } },
    { "!ventures",      { ACE, CW, WEW } },
--    { "!whereisdi",     { ACE, CW, WEW } },
}

commandObj.onTrigger = function(player)
    local charType = 0

    if player:isCrystalWarrior() then
        charType = 1
    elseif player:isClassicMode() then
        charType = 2
    end

    local str1 = "Available commands: "
    local str2 = ""

    for _, command in pairs(cmd) do
        if utils.contains(charType, command[2]) then
            if string.len(str1) > 130 then
                str2 = fmt("{}{} ", str2, command[1])
            else
                str1 = fmt("{}{} ", str1, command[1])
            end
        end
    end

    player:fmt(str1)

    if str2 ~= "" then
        player:fmt(str2)
    end
end

return commandObj
