-----------------------------------
-- func: fatigue
-- desc: Tells players their remaining daily fishing limit
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = ""
}

local minLimit = 20
local maxLimit = 300

commandObj.onTrigger = function(player, arg)
    if player:isCrystalWarrior() then
        player:sys("You have no daily fishing limit.")
        return
    end

    local caught   = player:getCharVar("[FISHING]CAUGHT")
    local modValue = player:getMod(xi.mod.FATIGUE)
    local limit    = maxLimit

    if player:isClassicMode() then
        if
            player:hasCompletedQuest(xi.questLog.OTHER_AREAS, xi.quest.id.otherAreas.ELDER_MEMORIES) or
            player:hasCompletedQuest(xi.questLog.OTHER_AREAS, xi.quest.id.otherAreas.THE_OLD_LADY)
        then
            limit = maxLimit
        else
            limit = minLimit
        end
    else
        if player:hasCompletedQuest(xi.questLog.JEUNO, xi.quest.id.jeuno.WHENCE_BLOWS_THE_WIND) then
            limit = maxLimit
        else
            limit = minLimit
        end
    end

    limit = math.floor(limit * (1 + (modValue / 100)))

    if modValue > 0 then
        player:sys("You've caught {}/{} (+{}%) of your daily fishing limit.", caught, limit, modValue)
    else
        player:sys("You've caught {}/{} of your daily fishing limit.", caught, limit)
    end
end

return commandObj
