-----------------------------------
-- func: essences
-- desc: provide player with a list of their Dynamis 2.0 Essences (Wins)
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = ''
}

local essences =
{
    'Arch Orc Essence',      -- 0
    'Arch Quadav Essence',   -- 1
    'Arch Yagudo Essence',   -- 2
    'Arch Goblin Essence',   -- 3
    'Arch Ahriman Esssence', -- 4
    'Arch Lord Esssence',    -- 5
    'Arch Morbol Essence',   -- 6
    'Arch Dragon Essence',   -- 7
    'Arch Gigas Essence',    -- 8
    'Arch Avatar Essence',   -- 9
}

commandObj.onTrigger = function(player)
    local progress = player:getCharVar('[NEO]PROGRESS')
    local result   = ''
    local result2  = ''
    local count    = 0

    for index, essence in pairs(essences) do
        if utils.mask.getBit(progress, index - 1) then

            if count > 5 then
                result2 = result2 .. essence .. ', '
            else
                result  = result  .. essence .. ', '
            end

            count = count + 1
        end
    end

    player:printToPlayer('A mysterious voice echoes...', xi.msg.channel.NS_SAY)
    if result ~= '' then
        player:printToPlayer('You possess the following Arch Essences:', xi.msg.channel.NS_SAY)
        player:printToPlayer(result, xi.msg.channel.NS_SAY)

        if count > 5 then
            player:printToPlayer(result2, xi.msg.channel.NS_SAY)
        end
    else
        player:printToPlayer('You do not possess any Arch Essences.', xi.msg.channel.NS_SAY)
    end
end

return commandObj
