-----------------------------------
-- func: dawnunstuck
-- desc: Releases the player from stuck event at CoP 8-4 DAWN.
-----------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = ""
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!release {name}")
end

commandObj.onTrigger = function(player)
    local target
    if name == nil then
        target = player
    else
        target = GetPlayerByName(name)
        if target == nil then
            error(player, string.format("Player named '%s' not found!", name))
            return
        end
    end

    if
	    target:getCurrentMission(xi.mission.log_id.COP) >= xi.mission.id.cop.DAWN and target:getZoneID() == 36
	then
	    target:printToPlayer("Attempting to unstuck you...")
        
		target:timer(2000, function(targetArg)
            target:setPos(target:getXPos(), target:getYPos(), target:getZPos(), target:getRotPos(), target:getZoneID())
        end)
    end
end

return commandObj
