-----------------------------------
-- func: dailykills
-- desc: Displays remaining kill amount for Murdoc's daily quest to players
-----------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = "s"
}

-- Handles the functionality of the "daily reset" at midnight
local handleMidnight = function(player)
    local questMidnight = player:getCharVar("[DQ]Midnight")
    local currentMidnight = getMidnight()

    -- handle first time quest midnight
    if questMidnight == 0 then
        player:setCharVar("[DQ]Midnight", currentMidnight)
        player:setCharVar("[DQ]Completed", 0)
        player:setCharVar("[DQ]Reset", 0)
        player:setCharVar("[DQ]Fishstix", 0)
        player:setCharVar("[DQ]Fishstix_Z", 0)
        player:setCharVar("[DQ]Murdoc", 0)
        player:setCharVar("[DQ]Murdoc_Z", 0)
        player:setCharVar("[DQ]Murdoc_MT", 0)
        player:setCharVar("[DQ]Murdoc_KA", 0)
        player:setCharVar("[DQ]Mistrix", 0)
        player:setCharVar("[DQ]Mistrix_I", 0)
        player:setCharVar("[DQ]Saltlik", 0)
        player:setCharVar("[DQ]Saltlik_Z", 0)
        player:setCharVar("[DQ]Saltlik_NM", 0)
        player:setCharVar("[DQ]Beetrix", 0)
        player:setCharVar("[DQ]Beetrix_Z", 0)
        player:setCharVar("[DQ]Beetrix_RE", 0)
    end
    
    -- handle midnight reset
    if currentMidnight ~= questMidnight then
        player:setCharVar("[DQ]Midnight", currentMidnight)
        player:setCharVar("[DQ]Completed", 0)
        player:setCharVar("[DQ]Reset", 0)
        player:setCharVar("[DQ]Fishstix", 0)
        player:setCharVar("[DQ]Fishstix_Z", 0)
        player:setCharVar("[DQ]Murdoc", 0)
        player:setCharVar("[DQ]Murdoc_Z", 0)
        player:setCharVar("[DQ]Murdoc_MT", 0)
        player:setCharVar("[DQ]Murdoc_KA", 0)
        player:setCharVar("[DQ]Mistrix", 0)
        player:setCharVar("[DQ]Mistrix_I", 0)
        player:setCharVar("[DQ]Saltlik", 0)
        player:setCharVar("[DQ]Saltlik_Z", 0)
        player:setCharVar("[DQ]Saltlik_NM", 0)
        player:setCharVar("[DQ]Beetrix", 0)
        player:setCharVar("[DQ]Beetrix_Z", 0)
        player:setCharVar("[DQ]Beetrix_RE", 0)
    end
end

-- This function is meant to allow the players to check their kill progress for the Murdoc quest
commandObj.onTrigger = function(player)
    handleMidnight(player)
    local murdocStage = player:getCharVar("[DQ]Murdoc")
    local murdocKillAmt = player:getCharVar("[DQ]Murdoc_KA")
    if murdocStage == 0 then
        player:printToPlayer("You do not have a current daily quest assigned to you from Murdoc.")
    elseif murdocStage == 1 then
        player:printToPlayer(string.format("You have %d kills remaining for Murdoc's daily quest.", murdocKillAmt))
    elseif murdocStage == 2 then
        player:printToPlayer("You have killed every mob required of you, please return to Murdoc for your reward.")
    elseif murdocStage == 3 then
        player:printToPlayer("You've already completed this quest today! Come back tomorrow for more.")
    end
end

return commandObj
