-----------------------------------
-- func: currency
-- desc: Displayed total currency stored across all systems
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = ''
}

local function addCommas(n)
    return tostring(math.floor(n)):reverse():gsub("(%d%d%d)","%1,"):gsub(",(%-?)$","%1"):reverse()
end

local function addStored(player, single, hundred, label, current, str)
    local result = str
    local amount = player:getCharVar(single)

    if hundred ~= nil then
        amount = amount + (player:getCharVar(hundred) * 100)
    end

    if amount > 0 then
        if string.len(result) > 0 then
            result = result .. fmt(", {}: {}", label, addCommas(amount))
        else
            result = result .. fmt("{}: {}", label, addCommas(amount))
        end
    end

    return (current + amount), result
end

local function addInventory(player, single, hundred, tenthousand, label)
    local result = ""
    local amount = player:getItemCount(single)

    if hundred ~= nil then
        amount = amount + (player:getItemCount(hundred) * 100) + (player:getItemCount(tenthousand) * 10000)
    end

    if amount > 0 then
        result = fmt("{}: {}", label, addCommas(amount))
    end

    return amount, result
end

commandObj.onTrigger = function(player)
    local byneStr  = ""
    local pieceStr = ""
    local shellStr = ""
    local alexStr  = ""
    local bayldStr = ""

    local bynes    = 0
    local pieces   = 0
    local shells   = 0
    local alex     = 0
    local bayld    = 0

    bynes,  byneStr  = addInventory(player, 1455, 1456, 1457, "Inventory")
    pieces, pieceStr = addInventory(player, 1452, 1453, 1454, "Inventory")
    shells, shellStr = addInventory(player, 1449, 1450, 1451, "Inventory")
    alex,   alexStr  = addInventory(player, 2488,  nil,  nil, "Inventory")
    bayld,  bayldStr = addInventory(player, 8798,  nil,  nil, "Inventory")

    bynes,  byneStr  = addStored(player, "[NEO]STORED_1455",    "[NEO]STORED_1456", "Freya",     bynes,  byneStr)
    pieces, pieceStr = addStored(player, "[NEO]STORED_1452",    "[NEO]STORED_1453", "Freya",     pieces, pieceStr)
    shells, shellStr = addStored(player, "[NEO]STORED_1449",    "[NEO]STORED_1450", "Freya",     shells, shellStr)
    alex,   alexStr  = addStored(player, "Paparoon_AlexStored",                nil, "Paparoon",  alex,   alexStr)
    bayld,  bayldStr = addStored(player, "[Domain]Bayld",                      nil, "D.Officer", bayld,  bayldStr)

    if player:isCrystalWarrior() then
        bynes,  byneStr  = addStored(player, "[EB]1455", "[EB]1456", "E.Box", bynes,  byneStr)
        pieces, pieceStr = addStored(player, "[EB]1452", "[EB]1453", "E.Box", pieces, pieceStr)
        shells, shellStr = addStored(player, "[EB]1449", "[EB]1450", "E.Box", shells, shellStr)
        alex,   alexStr  = addStored(player, "[EB]2488",        nil, "E.Box", alex,   alexStr)
        bayld,  bayldStr = addStored(player, "[EB]8798",        nil, "E.Box", bayld,  bayldStr)
    end

    player:fmt("Byne Bills:    {} ({})", addCommas(bynes),  byneStr)
    player:fmt("Bronzepieces: {} ({})",  addCommas(pieces), pieceStr)
    player:fmt("Whiteshells:   {} ({})", addCommas(shells), shellStr)
    player:fmt("Alexandrite:   {} ({})", addCommas(alex),   alexStr)
    player:fmt("H-P Bayld:     {} ({})", addCommas(bayld),  bayldStr)

    if player:isCrystalWarrior() then
        local steelStr  = ""
        local brassStr  = ""
        local silverStr = ""
        local steel     = 0
        local brass     = 0
        local silver    = 0

        steel,  steelStr  = addInventory(player, 3951, nil, nil, "Inventory")
        brass,  brassStr  = addInventory(player, 3952, nil, nil, "Inventory")
        silver, silverStr = addInventory(player, 3953, nil, nil, "Inventory")

        steel,  steelStr  = addStored(player, "[EB]3951", nil, "E.Box", steel, steelStr)
        brass,  brassStr  = addStored(player, "[EB]3952", nil, "E.Box", brass, brassStr)
        silver, silverStr = addStored(player, "[EB]3953", nil, "E.Box", silver, silverStr)
        player:fmt("Incursion:     Orcish = {} ({}), Quadav = {} ({}), Yagudo = {} ({})", steel, steelStr, brass, brassStr, silver, silverStr)
    end
end

return commandObj
