----------------------------------
-- func: !config (setting) (value)
-- desc: Allows players to customize their CatsEyeXI experience
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = "ss"
}

local function error(player)
    player:printToPlayer("!config (setting) (on/off)")
end

local values =
{
    ["on"]    = 1,
    ["off"]   = 1,
    ["true"]  = 1,
    ["false"] = 1,
    ["0"]     = 1,
    ["1"]     = 1,
}

commandObj.onTrigger = function(player, name, value)
    if
        name  == nil or
        value == nil
    then
        local current = player:getCharVar(cexi.settingVar)
        player:fmt("Your current settings:")

        for listName, listValue in pairs(cexi.setting) do
            if utils.mask.getBit(current, listValue) then
                player:fmt("{}: True", listName)
            else
                player:fmt("{}: False", listName)
            end
        end
    end

    local settingName  = string.upper(name)
    local settingValue = string.lower(value)
    local settingID    = cexi.setting[settingName]

    if settingID == nil then
        return player:fmt("This setting does not exist.")
    end

    if values[settingValue] == nil then
        return error(player)
    end

    local current = player:getCharVar(cexi.settingVar)
    local result  = current

    if
        settingValue == "on" or
        settingValue == "true" or
        settingValue == "1"
    then
        result = utils.mask.setBit(current, settingID, true)
        player:sys("Your {} setting is now set to True.", settingName)
    else
        result = utils.mask.setBit(current, settingID, false)
        player:sys("Your {} setting is now set to False.", settingName)
    end

    player:setCharVar(cexi.settingVar, result)
end

return commandObj
