-----------------------------
-- func: !chef
-- desc: opens a Chef Shop.
-----------------------------
local cq = require('modules/catseyexi/lua/additive_overrides/utils/custom_quest')
-----------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = "i"
}

local allowedZones =
{
    xi.zone.PORT_SAN_DORIA,
    xi.zone.NORTHERN_SAN_DORIA,
    xi.zone.SOUTHERN_SAN_DORIA,
    xi.zone.PORT_BASTOK,
    xi.zone.BASTOK_MINES,
    xi.zone.BASTOK_MARKETS,
    xi.zone.WINDURST_WATERS,
    xi.zone.PORT_WINDURST,
    xi.zone.WINDURST_WALLS,
    xi.zone.WINDURST_WOODS,
    xi.zone.SOUTHERN_SAN_DORIA_S,
    xi.zone.BASTOK_MARKETS_S,
    xi.zone.WINDURST_WATERS_S,
    xi.zone.SELBINA,
    xi.zone.RABAO,
    xi.zone.NORG,
    xi.zone.RULUDE_GARDENS,
    xi.zone.UPPER_JEUNO,
    xi.zone.LOWER_JEUNO,
    xi.zone.PORT_JEUNO,
    xi.zone.METALWORKS,
    xi.zone.MHAURA,
    xi.zone.KAZHAM,
    xi.zone.AL_ZAHBI,
    xi.zone.AHT_URHGAN_WHITEGATE,
    xi.zone.NASHMAU,
    xi.zone.TAVNAZIAN_SAFEHOLD,
    xi.zone.CELENNIA_MEMORIAL_LIBRARY,
}

local fieldStock =
{
    { "Antacid",        4153, 8000 },  -- Antacid
    { "Meat Jerky",     4376, 2000 },  -- Meat Jerky
    { "Meat Mithkabob", 4381, 5000 },  -- Meat Mithkabob
    { "Couerl Sub",     5166, 7000 },  -- Couerl Sub
    { "Boiled Crab",    4456, 2000 },  -- Boiled Crab
    { "Fish Mithkabob", 4398, 5000 },  -- Fish Mithkabob
    { "Jack-o-Lantern", 4488, 2000 },  -- Jack-o-Lantern
    { "Tuna Sushi",     5150, 8000 },  -- Tuna Sushi
    { "Dorado Sushi",   5178, 8000 },  -- Dorado Sushi
    { "Apple Pie",      4413, 2000 },  -- Apple Pie
    { "Melon Pie",      4421, 2000 },  -- Melon Pie
    { "Cream Puff",     5718, 7000 },  -- Cream Puff
    { "Orange Juice",   4422, 2000 },  -- Orange Juice
    { "Melon Juice",    4424, 5000 },  -- Melon Juice
    { "Yagudo Drink",   4558, 7000 },  -- Yagudo Drink
}

local cityStock =
{
    4153, 8000, -- Antacid
    4376, 2000, -- Meat Jerky
    4381, 5000, -- Meat Mithkabob
    5166, 7000, -- Couerl Sub
    4456, 2000, -- Boiled Crab
    4398, 5000, -- Fish Mithkabob
    4488, 2000, -- Jack-o-Lantern
    5150, 8000, -- Tuna Sushi
    5178, 8000, -- Dorado Sushi
    4413, 2000, -- Apple Pie
    4421, 2000, -- Melon Pie
    5718, 7000, -- Cream Puff
    4422, 2000, -- Orange Juice
    4424, 5000, -- Melon Juice
    4558, 7000  -- Yagudo Drink
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function confirmTrade(player, npc, item)
    local confirmMenu =
    {
        title   = string.format('Purchase %s for %s gil?', item[1], item[3]),
        options =
        {
            {
                'No',
                function(playerArg)
                end,
            },
            {
                'Yes',
                function(playerArg)
                    if npcUtil.giveItem(player, item[2]) then
                        playerArg:delGil(item[3])

                        return
                    else
                        player:printToPlayer('Wandering Chef : Please return after sorting your inventory.', xi.msg.channel.NS_SAY)

                        return
                    end
                end,
            },
        },
    }

    delaySendMenu(player, confirmMenu)
end

commandObj.onTrigger = function(player, npc)
    local title       = 'Welcome to the Wandering Chef Shop'
    local currentZone = player:getZoneID()
    local inTown      = false

    if player:isCrystalWarrior() then
        player:printToPlayer("Your character type cannot use this command.", xi.msg.channel.SYSTEM_3)

        return
    end

    if player:hasEnmity() then
        player:messageSystem(xi.msg.system.TRUST_NO_ENMITY)

        return -1
    end

    for _, allowedZone in ipairs(allowedZones) do
        if currentZone == allowedZone then
            inTown = true
        end
    end

    if
        player:isClassicMode() and
        not inTown
    then
        player:printToPlayer('This command may only be used in cities.', xi.msg.channel.SYSTEM_3)
    elseif inTown then
        xi.shop.general(player, cityStock)
    else
        cexi.util.simpleShop(player, npc, fieldStock, confirmTrade, title)
    end
end

return commandObj
