-----------------------------------
-- func: wingsaccount
-- desc: return characters associated with a player's linked wings account
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 3,
    parameters = 's'
}

commandObj.onTrigger = function(player, catseyeAccountName)
    local result  = GetWingsAccount(catseyeAccountName)
    local accName = ''
    local outstr  = ''

    if
        result == nil or
        #result == 0
    then
        player:printToPlayer('That account does not have a linked WingsXI account.', xi.msg.channel.SYSTEM_3)
        return
    end

    for _, charInfo in pairs(result) do
        accName = charInfo[4]
        outstr  = outstr .. string.format('%s (%u %s), ', charInfo[1], charInfo[2], xi.jobNames[charInfo[3]][1])
    end

    outstr = string.format('(%s -> %s): %s', catseyeAccountName, accName, outstr)

    player:printToPlayer(outstr, xi.msg.channel.SYSTEM_3)
end

return commandObj
