-----------------------------------
-- func: addallweaponskills
-- desc: Adds all learned weaponskills to the given target. If no target then to the current player.
-----------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 4,
    parameters = "ss"
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!unlocksweaponskill {id} {player}")
end

commandObj.onTrigger = function(player, wsId, target)
    -- validate target
    local targ

    player:printToPlayer(string.format("WS ID: %s", wsId))

    wsId = tonumber(wsId) or xi.wsUnlock[string.upper(wsId)]

    if (wsId == nil) then
        error(player, "You must supply a weaponskill id.")
        return
    end

    if target then
        targ = GetPlayerByName(target)

        if not targ then
            error(player, string.format("Player named '%s' not found!", target))
            return
        end
    else
        targ = player
    end

    -- add all learned weaponskills
    targ:addLearnedWeaponskill(wsId)
    player:printToPlayer(string.format("%s has unlocked the weaponskill.", targ:getName()))
end

return commandObj
