---------------------------------------------------------------------------------------------------
-- func: spin
-- desc: Spins a player 180 degrees (127 rad)
---------------------------------------------------------------------------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 3,
    parameters = 's'
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer('!spin <player>')
end

commandObj.onTrigger = function(player, targ)
    local target = nil
    -- validate target
    if targ then
        target = GetPlayerByName(targ)
    elseif player:getCursorTarget() then
        target = player:getCursorTarget()
    else
        return error('Invalid target.')
    end

    target:setRotation(target:getRotPos() + 127)

    return player:printToPlayer(string.format("Hmm... let's see how much of a sussy wussy %s is!", target:getName()))
end

return commandObj
