-----------------------------------
-- func: !setvaroffline
-- desc: Sets player's var value
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = "ssi"
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!setvaroffline (playerName) (varName) (varValue")
end

commandObj.onTrigger = function(player, playerName, varName, varValue)
    if
        playerName == nil or
        varName    == nil
    then
        error(player, string.format("Player name or var name missing"))
        return
    end

    local result = SetOfflineVar(playerName, varName, varValue)

    if result then
        player:printToPlayer(string.format("%s's var %s has been updated to %u.", playerName, varName, varValue), xi.msg.channel.SYSTEM_3)
    else
        player:printToPlayer(string.format("Something went wrong. Unable to update %s's %s var to %u.", playerName, varName, varValue), xi.msg.channel.SYSTEM_3)
    end
end

return commandObj
