-----------------------------------
-- func: setname
-- desc: Set's the mob's name.
-----------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 3,
    parameters = "s"
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer('!setname <name>')
end

commandObj.onTrigger = function(player, name)
    local target = player:getCursorTarget()

    -- validate name
    if name == nil or
        target == nil
    then
        error(player, 'Invalid name or target.')
        return
    elseif target:getObjType() ~= xi.objType.MOB then
        error(player, 'Command can only be used on mobs.')
        return
    end

    target:renameEntity(string.format('%s', name))
end

return commandObj
