-----------------------------------
-- func: !getzone
-- desc: Prints player's zone ID
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = "s"
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!getzone (playerName)")
end

commandObj.onTrigger = function(player, playerName)
    if
        playerName == nil
    then
        error(player, string.format("Player name or var name missing"))
        return
    end

    local result = GetOfflineZone(playerName)
    player:printToPlayer(string.format("%s's zone ID is %u.", playerName, result), xi.msg.channel.SYSTEM_3)
end

return commandObj
