-----------------------------------
-- func: !getvaroffline
-- desc: Prints player's var value
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = "ss"
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!getvaroffline (playerName) (varName)")
end

commandObj.onTrigger = function(player, playerName, varName)
    if
        playerName == nil or
        varName    == nil
    then
        error(player, string.format("Player name or var name missing"))
        return
    end

    local result = GetOfflineVar(playerName, varName)
    player:printToPlayer(string.format("%s's var %s is %u.", playerName, varName, result), xi.msg.channel.SYSTEM_3)
end

return commandObj
