-----------------------------------
-- !getreferrals
-- Get friend referral information
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 2,
    parameters = 's'
}

local unclaimed = "\129\153"
local claimed   = "\129\154"

local levelBits =
{
    { bit =  1, ace = 25, cw = 10 },
    { bit =  4, ace = 50, cw = 20 },
    { bit = 16, ace = 75, cw = 30 },
}

local rewardBits =
{
    { bit =  2, slash = true  }, -- Reward 1
    { bit =  8, slash = true  }, -- Reward 2
    { bit = 32, slash = false }, -- Reward 3
}

local function getLevelReached(bitmask, charType)
    level = 1

    for _, levelInfo in pairs(levelBits) do
        if bit.band(bitmask, levelInfo.bit) == levelInfo.bit then
            if charType == "ACE" then
                level = levelInfo.ace
            else
                level = levelInfo.cw
            end
        end
    end

    return level
end

local function getRewardsClaimed(bitmask)
    local result = ""

    for _, rewardInfo in pairs(rewardBits) do
        if bit.band(bitmask, rewardInfo.bit) == rewardInfo.bit then
            result = result .. claimed
        else
            result = result .. unclaimed
        end

        if rewardInfo.slash then
            result = result .. "/"
        end
    end

    return result
end

commandObj.onTrigger = function(self, name)
    local player = self

    if name ~= nil then
        player = GetPlayerByName(name)
    end

    local points    = player:getReferralPoints()
    local referrals = player:getReferrals()

    self:sys("{}'s Friend Referrals:", player:getName())

    for _, referral in pairs(referrals) do
        local charType = "ACE"

        if referral[2] == 1 then
            charType = "CW"
        elseif referral[2] == 2 then
            charType = "WEW"
        end

        local levelReached   = getLevelReached(referral[3], charType)
        local rewardsClaimed = getRewardsClaimed(referral[3])

        self:fmt("{} ({}): {} (Level Reached: {}+ | Rewards Claimed: {})", referral[1], charType, referral[3], levelReached, rewardsClaimed)
    end

    self:sys("Referral Points: {}", points)
end

return commandObj
