-----------------------------------
-- func: getfishers
-- desc: Returns a list of all players who have recently fished.
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = ""
}

commandObj.onTrigger = function(player, playerName, itemName)
    local fishers = GetRecentFishers()

    for _, fisher in pairs(fishers) do
        player:printToPlayer(string.format("Zone: %s | Player Name: %s | Job Level: %d | Skill: %d", fisher.zoneName, fisher.playerName, fisher.jobLevel, fisher.skill), xi.msg.channel.SYSTEM_3)
    end
end

return commandObj
