-----------------------------------
-- func: !getcode
-- desc: Prints character's account verification code
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = "s"
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!getcode (accountName)")
end

commandObj.onTrigger = function(player, accountName)
    local result = player:getVerificationCode(accountName)

    if
        result ~= nil and
        string.len(result) > 0
    then
        player:printToPlayer(string.format("Account %s's verification code is: %s", accountName, result), xi.msg.channel.SYSTEM_3)
    else
        player:printToPlayer(string.format("Account %s does not have a verification code.", accountName), xi.msg.channel.SYSTEM_3)
    end
end

return commandObj
