-----------------------------------
-- func: getaug
-- Gets augs for itemID on the target
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = 'si'
}

local function error(player)
    player:printToPlayer('!getaug <name> <itemId>')
end

commandObj.onTrigger = function(player, target, itemId)
    if target == nil then
        error(player)
        return
    end

    local targ = player
    local item = itemId
    local num  = tonumber(target)

    if num ~= nil then
        item = num
    else
        targ = GetPlayerByName(target)

        if targ == nil then
            local targ = player:getCursorTarget()

            if targ == nil then
                targ = player
            end
        end
    end

    local result = cexi.util.augment.getAugments(targ, item)

    local str = fmt("{}'s {} has the following augments", targ:getName(), item)

    for _, n in pairs(result) do
        str = fmt("{}, {} = {}", str, n[1], n[2])
    end

    player:sys(str)
end

return commandObj
