-----------------------------------
-- func: fightcostume
-- desc: Sets the players current costume with fighting capability.
-----------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 2,
    parameters = "i"
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!costume <costumeID>")
end

commandObj.onTrigger = function(player, costumeId)
    -- validate costumeId
    if costumeId == nil or costumeId < 0 then
        error(player, "Invalid costumeID.")
        return
    end

    -- put on costume
    player:setCostume2(costumeId)
end

return commandObj
