-----------------------------------
-- Resets Dragonslaying instance for target player's alliance
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 2,
    parameters = "ss"
}

local dragons = set {
    "MIDGARDSORMR",
    "ARFARVEGR",
    "SKRUDNINGR",
    "BRJOTA",
}

local function err(player)
    player:sys("You must enter a valid player name and wyrm name.")
    player:sys( "!dsreset <player> <wyrm>" )
    player:sys("(Midgardsormr / Arfarvegr / Skrudningr / Brjota)")
end

commandObj.onTrigger = function(player, target, wyrm)
    if
        target == nil or
        wyrm == nil
    then
        return err(player)
    end

    local wyrmName = string.upper(wyrm)

    if dragons[wyrmName] == nil then
        return err(player)
    end

    local targ = GetPlayerByName(target)

    if targ == nil then
        return err(player)
    end

    local varName = fmt("[DS]INSTANCE_{}", wyrmName)

    cexi.util.forAlliance(targ, function(member)
        member:setCharVar(varName, 0)
    end)

    player:sys("This lockout has been reset for {}'s present alliance, remember to refund the spawner", target)
    player:sys("Golden Rings (9445): Midgardsormr, Arfarvegr, Skrudningr")
    player:sys("Golden Rings +1 (9446) for Brjota")
end

return commandObj
