-----------------------------------
-- func: delaccount
-- desc: delete account if there are no associated characters
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 3,
    parameters = 's'
}

commandObj.onTrigger = function(player, accountName)
    if accountName == nil then
            player:printToPlayer('Usage: !delaccount (name)\nAccount must not have any associated characters.', xi.msg.channel.NS_SAY)
        return
    end

    if DeleteEmptyAccount(accountName) then
        player:printToPlayer('Account \'' .. accountName .. '\' was successfully deleted!', xi.msg.channel.SYSTEM_3)
    else
        player:printToPlayer('Account \'' .. accountName .. '\' has existing characters or an other unknown error occurred.', xi.msg.channel.SYSTEM_3)
    end
end

return commandObj
