-----------------------------------
-- Dynamic Entity Here
-----------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = "s"
}

commandObj.onTrigger = function(player, str)
    local zone     = player:getZone()
    local name     = string.gsub(str, "_", " ")
    local fullName = "DE_" .. name
    local result   = zone:queryEntitiesByName(fullName)

    if result == nil then
        player:printToPlayer(string.format("Unable to find entity: %s", fullName))
        return
    end

    for k, v in pairs(result) do
        if
            v:isMob() and
            not v:isSpawned()
        then
            v:spawn()
            player:printToPlayer(string.format("%s spawned.", fullName))
        end

        if v:isNPC() then
            v:setStatus(xi.status.NORMAL)
            player:printToPlayer(string.format("%s made visible.", fullName))
        end

        v:setPos(player:getXPos(), player:getYPos(), player:getZPos(), player:getRotPos())
    end
end

return commandObj
