-----------------------------------
-- Dynamic Entity Goto
----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 2,
    parameters = "s"
}

local function gotoPos(player, mob)
    player:setPos(mob:getXPos(), mob:getYPos(), mob:getZPos(), mob:getRotPos())
end

commandObj.onTrigger = function(player, str)
    local zone     = player:getZone()
    local name     = string.gsub(str, "_", " ")
    local fullName = "DE_" .. name
    local result   = zone:queryEntitiesByName(fullName)

    if result == nil then
        player:printToPlayer(string.format("Unable to find entity: %s", fullName))
        return
    end

    for _, mob in pairs(result) do
        if
            mob:isMob() and
            not mob:isSpawned()
        then
            mob:spawn()
            player:printToPlayer(string.format("%s spawned.", fullName))
            gotoPos(player, mob)

        elseif mob:isNPC() then
            mob:setStatus(xi.status.NORMAL)
            player:printToPlayer(string.format("%s made visible.", fullName))
            gotoPos(player, mob)
        end
    end
end

return commandObj
