-----------------------------------
-- func: !charhasitem
-- desc: Check if offline player has item
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = "ss"
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!charhasitem (playerName) (itemName)")
end

commandObj.onTrigger = function(player, playerName, itemName)
    if
        playerName == nil or
        itemName   == nil
    then
        error(player, string.format("Player name or item name missing"))
        return
    end

    local itemID = GetItemIDByName(itemName)

    if itemID == 0 then
        player:printToPlayer(string.format("Item name '%s' not found.", itemName), xi.msg.channel.NS_SAY)
        return
    end

    local result     = HasCharItem(playerName, itemName)
    local formatItem = string.gsub(itemName, "_", " ")
    formatItem       = string.gsub(formatItem, "^%l", string.upper(string.sub(formatItem, 1, 1)))
    local formatName = string.gsub(playerName, "^%l", string.upper(string.sub(playerName, 1, 1)))

    if result then
        player:printToPlayer(string.format("%s has item %s (%u).", formatName, formatItem, itemID), xi.msg.channel.NS_SAY)
    else
        player:printToPlayer(string.format("%s does not have item %s (%u).", formatName, formatItem, itemID), xi.msg.channel.NS_SAY)
    end
end

return commandObj
