-----------------------------------
-- func: !chardelitem
-- desc: Delete item from offline player
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = "si"
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!chardelitem (playerName) (itemID)")
end

commandObj.onTrigger = function(player, playerName, itemID)
    if
        playerName == nil or
        itemID     == nil
    then
        error(player, string.format("Player name or item ID missing"))
        return
    end

    local result = DelCharItem(playerName, itemID)

    if result then
        player:printToPlayer(string.format("%s's item %u was removed.", playerName, itemID), xi.msg.channel.SYSTEM_3)
    else
        player:printToPlayer("Something went wrong.", xi.msg.channel.SYSTEM_3)
    end
end

return commandObj
