-----------------------------------
-- func: !wyrm
-- desc: Check progress of target Wyrm
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 3,
    parameters = ""
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!wyrm <target>")
end

commandObj.onTrigger = function(player, rot)
    local target = player:getCursorTarget()

    if
        target == nil or
        not target:isMob()
    then
        error(player, string.format("Target not valid."))
        return
    end

    local battleTime        = target:getBattleTime()
    local animation         = target:getAnimationSub()
    local nextAction        = target:getLocalVar("nextAction")
    local magicBurstCounter = target:getLocalVar("magicBurstCounter")
    local timesLanded       = target:getLocalVar("timesLanded")
    local nextWindow        = target:getLocalVar("nextWindow")

    player:sys("{} ({}/{} ~ {}%) Time: {}, Mode: {}, Next action: {}", target:getName(), target:getHP(), target:getMaxHP(), target:getHPP(), battleTime, animation, nextAction)
    player:sys(" Magic burst counter: {}/20, Times landed: {}, Next window: {}", magicBurstCounter, timesLanded, nextWindow)
end

return commandObj
