-----------------------------------
-- func: !testevent
-- desc: Tests Custom Events
-- example: !testevent despawn Old_Hermit
-----------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = "ssi"
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!testevent (event) (npc) (param)")
end

local eventTable =
{
    despawn = function(npc, player)
        npc:ceDespawn(player)
    end,

    spawn = function(npc, player)
        npc:ceSpawn(player)
    end,

    emote = function(npc, player, param)
        npc:ceEmote(player, param, xi.emoteMode.MOTION)
    end,
}

commandObj.onTrigger = function(player, eventName, entityName, param)
    local zone = player:getZone()
    local deEntity = string.gsub(entityName, "_", " ")
    local results = zone:queryEntitiesByName("DE_" .. deEntity)

    if results == nil then
        error(player, string.format("Entity %s not found!", entityName))
        return
    end

    if eventName == nil then
        error(player, "No event name provided!")
        return
    end

    if eventTable[eventName] == nil then
        error(player, string.format("Event \"%s\" not found!", eventName))
        return
    end

    for i = 1, #results do
        eventTable[eventName](results[i], player, param)
    end
end

return commandObj
