-----------------------------------
-- func: !setrot
-- desc: Sets the target entity's rotation
-----------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = "i"
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!setrot (angle)")
end

commandObj.onTrigger = function(player, rot)
    local target = player:getCursorTarget()

    if rot == nil then
        error(player, string.format("Target is not a mob or NPC"))

    elseif target ~= nil and target:isMob() or target:isNPC() then
        local currentRot = target:getRotPos()
        target:setRotation(rot)
        player:printToPlayer(string.format("%s's rotation has been updated from %i to %i.", target:getName(), currentRot, rot), xi.msg.channel.SYSTEM_3)

    else
        error(player, string.format("Target is not a mob or NPC"))
    end
end

return commandObj
